import { Repository, DataSource } from 'typeorm';
import { Order } from '../../entities/order.entity';
import { OrderDetail } from '../../entities/order-detail.entity';
import { Product } from '../../entities/product.entity';
import { Customer } from '../../entities/customer.entity';
import { CreateOrderDto, UpdateOrderStatusDto, OrderResponseDto } from './dto';
export declare class OrdersService {
    private readonly orderRepo;
    private readonly orderDetailRepo;
    private readonly productRepo;
    private readonly customerRepo;
    private readonly dataSource;
    constructor(orderRepo: Repository<Order>, orderDetailRepo: Repository<OrderDetail>, productRepo: Repository<Product>, customerRepo: Repository<Customer>, dataSource: DataSource);
    private generateOrderNumber;
    private toOrderResponseDto;
    create(createOrderDto: CreateOrderDto, customerId: string): Promise<OrderResponseDto>;
    findAll(): Promise<OrderResponseDto[]>;
    findOne(id: string): Promise<OrderResponseDto>;
    findByCustomer(customerId: string): Promise<OrderResponseDto[]>;
    updateStatus(id: string, updateOrderStatusDto: UpdateOrderStatusDto): Promise<OrderResponseDto>;
    cancelOrder(id: string, customerId?: string): Promise<OrderResponseDto>;
    getOrderStats(): Promise<{
        totalOrders: number;
        totalRevenue: number;
        statusCounts: any;
        recentOrders: OrderResponseDto[];
    }>;
}
